/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.sift;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.sift.AppenderTracker;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppenderTrackerImpl<E>
implements AppenderTracker<E> {
    Map<String, Entry> map = new HashMap<String, Entry>();
    Entry head;
    Entry tail = this.head = new Entry(null, null, 0L);
    long lastCheck = 0L;

    AppenderTrackerImpl() {
    }

    @Override
    public synchronized void put(String key, Appender<E> value2, long timestamp) {
        Entry entry2 = this.map.get(key);
        if (entry2 == null) {
            entry2 = new Entry(key, value2, timestamp);
            this.map.put(key, entry2);
        }
        this.moveToTail(entry2);
    }

    @Override
    public synchronized Appender<E> get(String key, long timestamp) {
        Entry existing = this.map.get(key);
        if (existing == null) {
            return null;
        }
        existing.setTimestamp(timestamp);
        this.moveToTail(existing);
        return existing.value;
    }

    @Override
    public synchronized void stopStaleAppenders(long now) {
        if (this.lastCheck + 1000L > now) {
            return;
        }
        this.lastCheck = now;
        while (this.head.value != null && this.isEntryStale(this.head, now)) {
            Appender appender = this.head.value;
            appender.stop();
            this.removeHead();
        }
    }

    @Override
    public synchronized void stopAndRemoveNow(String key) {
        Entry e = this.head;
        Entry found = null;
        while (e != this.tail) {
            if (key.equals(e.key)) {
                found = e;
                break;
            }
            e = e.next;
        }
        if (found != null) {
            this.rearrangePreexistingLinks(e);
            this.map.remove(key);
            Appender appender = e.value;
            appender.stop();
        }
    }

    @Override
    public List<String> keyList() {
        LinkedList<String> result2 = new LinkedList<String>();
        Entry e = this.head;
        while (e != this.tail) {
            result2.add(e.key);
            e = e.next;
        }
        return result2;
    }

    private boolean isEntryStale(Entry entry2, long now) {
        if (!entry2.value.isStarted()) {
            return true;
        }
        return entry2.timestamp + 1800000L < now;
    }

    private void removeHead() {
        this.map.remove(this.head.key);
        this.head = this.head.next;
        this.head.prev = null;
    }

    private void moveToTail(Entry e) {
        this.rearrangePreexistingLinks(e);
        this.rearrangeTailLinks(e);
    }

    private void rearrangePreexistingLinks(Entry e) {
        if (e.prev != null) {
            e.prev.next = e.next;
        }
        if (e.next != null) {
            e.next.prev = e.prev;
        }
        if (this.head == e) {
            this.head = e.next;
        }
    }

    private void rearrangeTailLinks(Entry e) {
        Entry preTail;
        if (this.head == this.tail) {
            this.head = e;
        }
        if ((preTail = this.tail.prev) != null) {
            preTail.next = e;
        }
        e.prev = preTail;
        e.next = this.tail;
        this.tail.prev = e;
    }

    public void dump() {
        Entry e = this.head;
        System.out.print("N:");
        while (e != null) {
            System.out.print(e.key + ", ");
            e = e.next;
        }
        System.out.println();
    }

    @Override
    public List<Appender<E>> valueList() {
        LinkedList result2 = new LinkedList();
        Entry e = this.head;
        while (e != this.tail) {
            result2.add(e.value);
            e = e.next;
        }
        return result2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Entry {
        Entry next;
        Entry prev;
        String key;
        Appender<E> value;
        long timestamp;

        Entry(String k, Appender<E> v, long timestamp) {
            this.key = k;
            this.value = v;
            this.timestamp = timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public int hashCode() {
            int prime = 31;
            int result2 = 1;
            result2 = 31 * result2 + (this.key == null ? 0 : this.key.hashCode());
            return result2;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public String toString() {
            return "(" + this.key + ", " + this.value + ")";
        }
    }
}

